#!/bin/bash

# ---------------------------------------------------------------------------
# START_DBUS
# ---------------------------------------------------------------------------
# Starts dbus
#   return : nothing
# ---------------------------------------------------------------------------
function start_dbus {
    logger -s "[START] dbus starting"
    /etc/init.d/S30dbus start > /dev/null
}

function start_network_old {
    logger -s "[START] set wifi zone"
    
    if [ -f /etc/conf/wifi_country.conf ] ; then
        COUNTRY=$(cat /etc/conf/wifi_country.conf)
        export COUNTRY
        /usr/sbin/iw reg set $COUNTRY
        /usr/sbin/crda
        logger -s "[START] set wifi country to $COUNTRY"
    else
        logger -s "[START] no wifi country information"
    fi

    logger -s "[START] network."
    /usr/sbin/wpa_supplicant -Dwext -iwlan0 -u -B
    mkdir -p /var/lib/
    if [ ! -f /etc/conf/connman/default.profile ] ; then
        mkdir -p /etc/conf/connman/
        touch /etc/conf/connman/default.profile
    fi
    ln -s /etc/conf/connman /var/lib/
    /usr/sbin/connmand
}

# ---------------------------------------------------------------------------
# CHECK_UPDATES
# ---------------------------------------------------------------------------
# Checks if any rootfs or yaffs updates are available. If updates are
# available, they are downloaded and the karotz is rebooted.
#   return : 0 if there are no updates
#            1 if there are updates but they failed to be downloaded or
#              installed
#            never if there is an update and it has been successfully applied
# ---------------------------------------------------------------------------
function check_updates {
    logger -s "[START] checking updates."
    /karotz/scripts/update_rootfs.sh
    /karotz/scripts/update_yaffs.sh
}

# ---------------------------------------------------------------------------
# WAIT_UNTIL_CONNECTED
# ---------------------------------------------------------------------------
# Waits until we're connected
#   For the record, sometimes network.conf disapears, network.conf.save is created
#   and stored in order to be retrieved in case of disapearance.
#   Using /etc/conf/network.conf.save to retrieve configuration is a patch here.
#   We should use something cleaner.
#   return : nothing
# ---------------------------------------------------------------------------
function wait_until_connected {
    # logger -s "[CONNECTION] not connected -> scanning"
    # echo 'karotz_net_rescan' | /usr/scripts/config.py
    # 
    # logger -s "[CONNECTION] wait until connected."
    # COUNT=0
    # while /bin/true ; do
    #     if is_connected ; then
    #         unset COUNT
    #         return 0
    #     fi
    #     COUNT=$(( $COUNT + 1 ))
    #     if [ $COUNT -lt 4 ] ; then # To much attempts
    #         logger -s "[CONNECTION] still not connected, attempt $COUNT"
    #         sleep 1
    #     elif connection_has_failed ; then # Connman failure
    #         logger -s "[CONNECTION] connection has failed -> reconfiguring"
    #         cat /etc/conf/network.conf | /usr/scripts/config.py
    #         continue
    #     else
    #         logger -s "[CONNECTION] still not connected -> rescanning"
    #         echo 'karotz_net_rescan' | /usr/scripts/config.py
    #         cat /etc/conf/network.conf | /usr/scripts/config.py
    #     fi
    # done
    echo error
}

# ---------------------------------------------------------------------------
# MONITOR_CONNECTION
# ---------------------------------------------------------------------------
# Restarts connection if it went down
#   return : nothing
# ---------------------------------------------------------------------------
function monitor_connection {
    logger -s "[MONITORING] starting connection monitoring"
    logger -s "[MONITORING] testing connection"
    if ! test_internet_connectivity ; then
        logger -s "[MONITORING] connection lost"
        wait_until_connected
    fi
}
