#!/usr/bin/python

import sys
sys.path.append( "/karotz/scripts" )
sys.path.append( "/usr/scripts" )
import os
import time
import config
import network 
from led_functions import *

def wait_until_connected(led=False):
     
    if os.path.isfile("/etc/conf/wifi_country.conf"):
        file_country = open("/etc/conf/wifi_country.conf", "r")
        str_country = file_country.read()
        str_country = str_country.rstrip()
        file_country.close()
        if str_country != "":
            os.system("logger -s \"[START] setting wifi country\"")
            os.system("COUNTRY="+str_country + "; export COUNTRY; /usr/sbin/iw reg set "+str_country + "; /usr/sbin/crda")
        else:
            os.system("logger -s \"[START] wifi country information not valid\"")
    else:
        os.system("logger -s \"[START] no wifi country information\"")
    
    network.lo_up()
    network.eth0_up()
    network.wlan0_up()
    
    if not os.path.isfile("/etc/conf/voos.conf"):
        os.system("logger -s \"[START] voos.conf missing\"")
        sys.exit(1)
    
    ethernet=False
    wifi=False
    
    if network.eth0_up() == 0 and os.path.isfile("/etc/conf/ip_eth0.conf"):
        ethernet=True
    
    if os.path.isfile("/etc/conf/wifi.conf") and os.path.isfile("/etc/conf/ip_wlan0.conf"):
        wifi=True
    
    if not ethernet and not wifi:
        os.system("logger -s \"[START] network files missing\"")
        sys.exit(1)
    
    if ethernet:
        network.wlan0_down()
    
    if led: led_end_of_boot()
    
    if network.is_connected() == 0:
        sys.exit(0)
    
    while 1:
        os.system("logger -s \"[START] loading wifi config\"")
        if not ethernet and wifi:
            config.load_wifi()
            if not network.wait_wifi_status(300):
                continue 
        
        if ethernet: config.load_ip("eth0")
        if wifi: config.load_ip("wlan0")
    
        os.system("logger -s \"[START] asking for ip\"")
        if not network.wait_ip(300): 
            continue
        os.system("logger -s \"[START] network is ready to go\"")
        break

# main

if len(sys.argv) > 1 and sys.argv[1] == "--quiet":
    wait_until_connected(False)
else:
    wait_until_connected(True)

sys.exit(0)

# def wait_wifi_status(timeout):
#     start=time.time()
#     while time.time() - start < timeout:
#         res = network.get_wifi_status()
#         if res != "Not-Associated": return True
#         time.sleep(1)
#     return False
# 
# def wait_ip(timeout):
#     start=time.time()
#     while time.time() - start < timeout:
#         if network.is_connected() == 0: return True
#         time.sleep(1)
#     return False  

# if os.path.isfile("/etc/conf/wifi_country.conf"):
#     conf = os.popen("cat /etc/conf/wifi_country.conf")
#     str_country = conf.read()
#     conf.close()
#     if str_country != "":
#         os.system("logger -s \"[START] setting wifi country\"")
#         os.system("/usr/sbin/iw reg set "+str_country)
#         os.system("COUNTRY="+str_country+";export COUNTRY;/usr/sbin/crda")
#     else:
#         os.system("logger -s \"[START] wifi country information not valid\"")
# else:
#     os.system("logger -s \"[START] no wifi country information\"")
# 
# network.lo_up()
# network.eth0_up()
# network.wlan0_up()
# 
# if not os.path.isfile("/etc/conf/voos.conf"):
#     os.system("logger -s \"[START] voos.conf missing\"")
#     sys.exit(1)
# 
# ethernet=False
# wifi=False
# 
# if network.eth0_up() == 0 and os.path.isfile("/etc/conf/ip_eth0.conf"):
#     ethernet=True
# 
# if os.path.isfile("/etc/conf/wifi.conf") and os.path.isfile("/etc/conf/ip_wlan0.conf"):
#     wifi=True
# 
# if not ethernet and not wifi:
#     os.system("logger -s \"[START] network files missing\"")
#     sys.exit(1)
# 
# if ethernet:
#     network.wlan0_down()
# 
# led_end_of_boot()
# 
# if network.is_connected() == 0:
#     sys.exit(0)
# 
# while 1:
#     os.system("logger -s \"[START] loading wifi config\"")
#     if not ethernet and wifi:
#         config.load_wifi()
#         if not wait_wifi_status(300):
#             continue 
#     
#     if ethernet: config.load_ip("eth0")
#     if wifi: config.load_ip("wlan0")
# 
#     os.system("logger -s \"[START] asking for ip\"")
#     if not wait_ip(300): 
#         continue
#     os.system("logger -s \"[START] network is ready to go\"")
#     break
# 
# sys.exit(0)

