#!/bin/bash

MY_IP=$(ifconfig | grep 'inet addr:'| grep -v '127.0.0.1' | cut -d: -f2 | awk '{ print $1}')
K2K_CMD_PORT=4242
K2K_LISTEN_PORT=4243

K2K_TALK_PIDFILE="/var/run/k2k_talk.pid"
K2K_LISTEN_PIDFILE="/var/run/k2k_listen.pid"
K2K_REMOTEIP_FILE="/var/run/k2k_remoteip"

function k2k_pidfile_kill {
    PIDFILE=$1
    if [ -f "$PIDFILE" ] ; then
        kill -9 $(cat "$PIDFILE")
        rm -f $PIDFILE
    else
        echo "No file $PIDFILE"
    fi
}

function k2k_launch_listen {
    nc -l -p $K2K_LISTEN_PORT | /usr/scripts/k2k/playback &
    echo $! > "$K2K_LISTEN_PIDFILE"
}

function k2k_launch_talk {
    REMOTE_IP=$(cat "$K2K_REMOTEIP_FILE")
    /usr/scripts/k2k/rec | nc $REMOTE_IP $K2K_LISTEN_PORT &
    echo $! > "$K2K_TALK_PIDFILE"
}
