#/bin/bash

# listens on port K2K_PORT for incoming calls

cd $(dirname $0)
. k2k_setup.sh

while /bin/true ; do
    nc -l -p $K2K_CMD_PORT | while read line ; do
        case $line in
            ip:* ) # a remote karotz wants to initiate a connexion
                REMOTE_IP=$(echo $line | cut -d':' -f2)

                logger -s "k2k. Will launch k2k session with $REMOTE_IP"
                echo $REMOTE_IP > /var/run/k2k_remoteip

                # launch k2k
                logger -s "k2k. connecting to other side"
                k2k_launch_talk

                logger -s "k2k. opening listening server"
                k2k_launch_listen

                logger -s "k2k. telling other side to connect to us"
                # tell the other side to connect
                echo "ip2:$MY_IP" | nc $REMOTE_IP $K2K_CMD_PORT
                ;;

            ip2:* ) # we have initiated a connexion, and other side has done its job
                # other side has connected to us and launched server
                REMOTE_IP=$(echo $line | cut -d':' -f2)
                echo $REMOTE_IP > /var/run/k2k_remoteip

                logger -s "k2k. other side has done its work. connect to them."
                k2k_launch_talk
                # here, connexion is opened both sides. talk.
                ;;

            stop )
                logger -s "k2k. other side wants to stop."
                # kill k2k, both sides
                k2k_pidfile_kill "$K2K_TALK_PIDFILE"
                k2k_pidfile_kill "$K2K_LISTEN_PIDFILE"
                [ -f "$K2K_REMOTEIP_FILE" ] && rm -f "$K2K_REMOTEIP_FILE"
                ;;

            *)
                logger -s "k2k. unrecognized line $line"
                ;;
        esac
    done
    logger -s "k2k. Relaunching listen script."
done
