#/bin/bash

cd $(dirname $0)
. k2k_setup.sh


function usage {
    echo "Usage: $(basename $0) <remote_ip_addr>"
    exit 1
}

[ $# -eq 1 ] || usage

REMOTE_IP=$1

logger -s "k2k. launching listen."

# launch listening k2k
k2k_launch_listen

logger -s "k2k. opening connection to $REMOTE_IP"

# initiate connexion
echo "ip:$MY_IP" | nc $REMOTE_IP $K2K_CMD_PORT

logger -s "k2k. done"
