#!/usr/bin/python

import os
import sys
import shutil
import network
#import time
from encodings import hex_codec
import simplejson as json

# answears "iamkarotz" to "karotz_ping"
def ping(line):
    return {'response':'OK'}

def start_syslogd(cmd):
    open('/etc/conf/enable_syslogd','w').close()
    res = 0
    running = os.system('pidof syslogd > /dev/null')
    if running != 0:
        res = os.system("/sbin/syslogd 2>/dev/null")
    if res != 0:
        return {'response':'ERROR'}
    else:
        return {'response':'OK'}

def stop_syslogd(cmd):
    if os.path.exists('/etc/conf/enable_syslogd'):
        os.unlink('/etc/conf/enable_syslogd')
    os.system("/bin/killall syslogd 2>/dev/null")
    return {'response':'OK'}

def get_syslogd(cmd):
    logs=""
    numLine = 100
    if "lines" in cmd:
        numLine = cmd["lines"]
    if os.path.exists('/var/log/messages'):
        logCmd = os.popen("tail -n %d /var/log/messages" % (numLine))
        logs = logCmd.read()
        logCmd.close()
    return {'response':'OK', 'log': logs}

def set_pass(cmd):
    if 'pwd' not in cmd:
        return {'response':'ERROR', 'desc':'need password'}

    try:
        file = open('/etc/conf/voos.conf', 'w')
        file.write('[voos]\n')
        file.write('id=')
        file.write(__get_id())
        file.write('\npwd=')
        file.write(cmd['pwd'])
        file.write('\n')
        file.close()
    except:
        return {'response':'ERROR', 'desc':'cannot write config'}

    return {'response':'OK'}

def reboot(cmd):
    os.system("(sleep 3 ; /sbin/reboot) &")
    return {'response':'OK'}

def get_id(cmd):
    return {'response':'OK', 'id': __get_id()}

def get_sys_version(cmd):
    file = "/etc/conf/sys_version"
    if not os.path.exists(file):
        return {'response':'ERROR', 'desc':'cannot find file'}
    fs_version_file = open(file)
    fs_version = fs_version_file.read().strip()
    fs_version_file.close()
    return {'response':'OK', 'version': fs_version}

def get_rootfs_version(cmd):
    file = "/etc/conf/rootfs_version"
    if not os.path.exists(file):
        return {'response':'ERROR', 'desc':'cannot find file'}
    fs_version_file = open(file)
    fs_version = fs_version_file.read().strip()
    fs_version_file.close()
    return {'response':'OK', 'version': fs_version}

def __get_mac(interface="wlan0"):
    if interface != "eth0":
        interface = "wlan0"
    macCmd = os.popen("ifconfig | egrep '^" + interface + "'")
    macAddress = macCmd.readline().strip().split()[-1]
    macCmd.close()
    return macAddress;

def get_mac(cmd):
    interface="wlan0"
    if 'interface' in cmd:
        interface = cmd['interface']
    try:
        return {'response':'OK', 'mac': __get_mac(interface)}
    except:
        return {'response':'ERROR'}

def get_networks(cmd):
    return {'response':'OK', 'networks': network.get_networks()}

def set_wifi(cmd, save=True):
    if 'encryption' not in cmd:
        return {'response':'ERROR', 'desc':'need encryption'}
    if 'ssid' not in cmd:
        return {'response':'ERROR', 'desc':'need ssid'}
        
    result = -1
    if cmd['encryption'] == 'open':
        result = network.connect_open(cmd['ssid'])
    elif cmd['encryption'] == 'wep':
        if 'key' not in cmd:
            return {'response':'ERROR', 'desc':'need key'}
        result = network.connect_wep(cmd['ssid'], cmd['key'])
    elif cmd['encryption'] == 'wpa' or cmd['encryption'] == 'wpa2':
        if 'settings' not in cmd:
            return {'response':'ERROR', 'desc':'need settings'}
        result = network.set_wpa_supplicant(cmd["settings"])
    if result == 0:
        if save:
            wifiFile = open("/etc/conf/wifi.conf", "w")
            wifiFile.write(cmd["__orig__"])
            wifiFile.close()
        return {'response':'OK'}
    else:
        return {'response':'ERROR'}
        
def load_wifi():
    wifiFile = open("/etc/conf/wifi.conf", "r")
    set_wifi(json.loads(wifiFile.read()), False);
    wifiFile.close()
        
def get_ip(cmd):
    interface = "wlan0"
    if 'interface' in cmd and cmd['interface']=="eth0":
        interface = "eth0"
    return {'response':'OK', 'ip' : network.get_ip(interface)};       
        
def set_ip(cmd, save=True):
    interface = "wlan0"
    if 'interface' in cmd and cmd['interface']=="eth0":
        interface = "eth0"
    if 'dhcp' in cmd and cmd['dhcp'] == True:
        network.set_dynamic_ip(interface)

    else:
        if 'ip' not in cmd:
            return {'response':'ERROR', 'desc':'need ip'}
        if 'netmask' not in cmd:
            return {'response':'ERROR', 'desc':'need netmask'}
        if 'gateway' not in cmd:
            return {'response':'ERROR', 'desc':'need gateway'}
        if 'nameserver' not in cmd:
            return {'response':'ERROR', 'desc':'need nameserver'}
        
        network.set_static_ip(cmd['ip'], cmd['netmask'], cmd['gateway'], cmd['nameserver'],interface)

    if save :
        ipFile = open("/etc/conf/ip_%s.conf" % (interface), "w")
        ipFile.write(cmd["__orig__"])
        ipFile.close()
    return {'response':'OK'}

def load_ip(interface):
    if interface != "eth0":
        interface = "wlan0"
    ipFile = open("/etc/conf/ip_%s.conf" % (interface), "r")
    set_ip(json.loads(ipFile.read()), False);
    ipFile.close()

def get_wifi_status(cmd):
    return {'response':'OK', 'status': network.get_wifi_status()}
    
def is_connected(cmd):
    if network.is_connected() == 0:
        return {'response':'OK'}
    else:
        return {'response':'ERROR'}

def __get_id():
    global uniqueId
    if uniqueId == None:
        macCmd = os.popen("echo "+ __get_mac() +" 'AC353EFA-2B04-45BA-9BDA-FEEFA43BB640' | md5sum | cut -d' ' -f1")
        uniqueId = macCmd.readline().strip()
        macCmd.close()
    return uniqueId

def set_country(cmd):
    if 'code' not in cmd:
        return {'response':'ERROR', 'desc':'need code'}
    result = network.set_wifi_country(cmd["code"])
    if result == 0:
        return {'response':'OK'}
    else:
        return {'response':'ERROR'}
    return 

def get_iwlist(cmd):
    result = network.get_iwlist()
    return {'response':'OK', 'data': result}

def get_version(cmd):
    return {'response':'OK', 'version': 1.0}
    
uniqueId=None

cmdTab = {
    'ping':ping,
    'start_syslogd':start_syslogd,
    'stop_syslogd':stop_syslogd,
    'get_syslogd':get_syslogd,
    'set_pass':set_pass,
    'reboot':reboot,
    'get_id':get_id,
    'get_sys_version':get_sys_version,
    'get_rootfs_version':get_rootfs_version,
    'get_mac':get_mac,
    'get_networks':get_networks,
    'set_wifi':set_wifi,
    'set_ip':set_ip,
    'get_ip':get_ip,
    'is_connected':is_connected,
    'set_country':set_country,
    'get_iwlist':get_iwlist,
    'get_version':get_version,
    'get_wifi_status':get_wifi_status
}

def onReceivedLine(line):
    try:
        if len(line) > 0:
            cmdJson = json.loads(line)
            cmdJson["__orig__"]=line
            cmd = cmdJson["cmd"]
            if cmd in cmdTab:
                resultPython = cmdTab[cmd](cmdJson)
                resultJson = json.dumps(resultPython, sort_keys=True, indent=4)
                lines = resultJson.count('\n')
                serialFileW.write(str(lines+1)+'\n')
                serialFileW.write(resultJson+'\n')
            else:
                serialFileW.write('1\n')
                serialFileW.write(json.dumps({'response':'ERROR', 'desc':"command '%s' doesn't exists" % (cmd) })+'\n')
            return True;
        else:
            return False;
    except Exception, e:
        serialFileW.write('1\n')
        serialFileW.write(json.dumps({'response':'ERROR'})+'\n')
        raise e

def main():
    global serialFileW
    global serialFileR
    ttyDevice = "/dev/ttyGS0";
    

    
    cmd_line = raw_input().strip()
    
    if sys.argv.count('--cmd') > 0:
        serialFileR=sys.stdin
        serialFileW=sys.stdout
        
        onReceivedLine(cmd_line)
        sys.exit(0)
        
    serialFileW = open(ttyDevice, "w")
    serialFileR = open(ttyDevice, "r")
    # read command and obey
    while onReceivedLine(cmd_line):
        cmd_line = serialFileR.readline().strip()

if __name__ == "__main__":
    main()
